#!/usr/bin/env bash
set -e SERVER_IP="95.168.168.121" # <<< 
SET THIS DURATION=30 PARALLEL=8 
LOGFILE="$HOME/iperf3_speedtest_$(date 
+%Y%m%d_%H%M%S).log" echo 
"===============================" echo " Steam 
Deck Network Test" echo 
"==============================="
# WAN IP
echo "" echo "[+] Checking Public (WAN) IP..." 
PUBLIC_IP=$(curl -4 -s 
https://ipecho.net/plain || true) if [[ -z 
"$PUBLIC_IP" ]]; then
  echo "[!] Could not retrieve WAN IP." echo 
  "If needed, visit https://icanhazip.com"
else echo "Public Internet IP:" echo ">>> 
  $PUBLIC_IP <<<"
fi
# LAN IP
echo "" echo "[+] Local Network IP:" hostname 
-I 2>/dev/null || echo "Not available" echo "" 
echo "===============================" echo 
"SEND THIS PUBLIC IP TO YOUR BROTHER" echo "He 
will open firewall for this IP." echo 
"===============================" echo "" read 
-p "Press ENTER ONLY AFTER he says READY... " 
TMP
# ensure iperf
if ! command -v iperf3 >/dev/null 2>&1; then 
  echo "[+] Installing iperf3..." sudo pacman 
  -Sy --noconfirm iperf3 || {
    echo "[!] Failed to install iperf3 
    (SteamOS readonly or no sudo?)" exit 1
  }
else echo "[+] iperf3 installed." fi
# check connectivity
echo "" echo "[+] Checking connectivity to 
$SERVER_IP" if ! ping -c 2 "$SERVER_IP" 
>/dev/null 2>&1; then
  echo "[!] Cannot reach $SERVER_IP yet." exit 
  1
fi echo "" echo 
"=========================================" 
echo " Running FULL SPEED TEST" echo 
"=========================================" {
  echo "===== TCP DOWNLOAD ($DURATION s, 
  $PARALLEL streams) =====" iperf3 -c 
  "$SERVER_IP" -P "$PARALLEL" -t "$DURATION" 
  -O 2 echo "" echo "===== TCP UPLOAD 
  (reverse) =====" iperf3 -c "$SERVER_IP" -P 
  "$PARALLEL" -t "$DURATION" -O 2 -R echo "" 
  echo "===== UDP REALITY TEST =====" iperf3 
  -c "$SERVER_IP" -u -b 0 -t "$DURATION" 
  --get-server-output echo "" echo "===== 
  SINGLE STREAM REALISTIC TEST =====" iperf3 
  -c "$SERVER_IP" -t "$DURATION" -O 2
} | tee "$LOGFILE"
echo "" echo "🔥 Done. Log saved:"
echo "$LOGFILE"
